/******************************************************************************
* This public header file provides structure definition for different table
* structure whose size can be configured by the application.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*******************************************************************************/

#ifndef _NWK_GLOBALS_H_
#define _NWK_GLOBALS_H_

#include "EmbeddedTypes.h"
#include "NwkInterface.h"
#include "MsgSystem.h"
#include "TS_Interface.h"
#include "TMR_Interface.h"


/******************************************************************************
*******************************************************************************
* Public macros
*******************************************************************************
******************************************************************************/
#ifndef gZtcIncluded_d
#define gZtcIncluded_d        FALSE
#endif

#ifndef gBlackBoxIncluded_d
#define gBlackBoxIncluded_d   FALSE
#endif


#ifndef gOtaBootloader_d
#define gOtaBootloader_d   FALSE
#endif


#if gZtcIncluded_d || gBlackBoxIncluded_d 
  #define CONST 
#else
  #define CONST const
#endif

/*******************************************************************************
********************************************************************************
* Public prototypes
********************************************************************************
*******************************************************************************/


/****************************************************************************
*****************************************************************************
* Public type definitions
*****************************************************************************
****************************************************************************/

/****************************************************************************/

/* Task / kernel identifiers. */

/* Reserved task priority ranges.
 * Task priority   0 is reserved by the kernel for the idle task.
 * Task priority 255 is reserved by the kernel as an invalid priority value.
 *
 * Higher number tasks run first.
 */

/* Reserve some IDs for low priority BeeStack tasks. */
#define gTsFirstNwkTaskPriorityLow_c        0x01
#define gTsZTCTaskPriority_c                0x02
#define gTsUartTaskPriority_c               0x03
#define gTsLCDTaskPriority_c                0x05


/* Set priority of I2C to be bigger than the one of accelerometer */
#define gTsI2CTaskPriority_c                0x10


/* Reserved for application tasks. */
#define gTsFirstApplicationTaskPriority_c   0x40

#ifdef gOtaBootloader_d
  /* Otap task. */
  #define gTsOtapTaskPriority_c             0x79

#endif

/* Application main task. */
#define gTsAppTaskPriority_c                0x80

/* Application FSL profiles tasks. */
#define gTsFSLProfileTaskPriority_c         0xA0

/* Application ZRC profiles tasks. */
#define gTsZRCProfileTaskPriority_c        0xA1

/* Application ZID profile tasks. */
#define gTsZIDProfileTaskPriority_c        0xA2

/* Application PBP profiles tasks. */
#define gTsPushButtonTaskPriority_c        0xA3


/* Reserved for high priority RF4CE tasks. */
#define gTsFirstNwkTaskPriorityHigh         0xC0
#define gTsNwkTaskPriority_c                0xC5
#define gTsMlmeTaskPriority_c               0xC6
#define gTsHighestTaskPriorityPlusOne_c     0xC7

#if gTsTimerTaskPriority_c < gTsHighestTaskPriorityPlusOne_c
#error The Timer Task must be the highest priority task.
#endif

/****************************************************************************
*****************************************************************************
* Public memory declarations
*****************************************************************************
****************************************************************************/

/* All the variables below are declared in Nwk_Globals.c in order to be configured by the application, 
   at compile time  */

/* Number of pair tables entries supported by the local node */
extern CONST  uint8_t     nwkcMaxPairingTableEntries;

/* Capabilities of the local node */
extern CONST  uint8_t     nwkcNodeCapabilities;
  
/* VendorId of the local node */
extern CONST  uint8_t     nwkcVendorId[2];

/* Vendor string of the local node */
extern CONST  uint8_t     nwkcVendorString[gSizeOfVendorString_c];

/* Frame counter window of the local node */
extern CONST  uint32_t    nwkcFrameCounterWindow;

/* Pair table of the local node */
extern        nodeData_t  nodeData;

/* Network NIB table */
extern        nwkNib_t    gNwkNib;

/****************************************************************************/
/* TaskIDs. The MAC library needs to know the IDs for some of the tasks, so
 * it can set events for them. But it is supplied as a binary library, so it
 * can't use #define or enum constants, and the TaskIDs might change. TaskIDs
 * are assigned dynamically by the kernel.
 * Instead, there is integer in RAM for each task that contains that task's
 * ID. This costs some RAM, but the MAC library only needs to know the names
 * of the integers, not the TaskIDs, at link time.
 */

#define Task( taskIdGlobal, taskInitFunc, taskMainFunc, priority ) \
  extern tsTaskID_t taskIdGlobal; \
  extern void taskInitFunc( void ); \
  extern void taskMainFunc( event_t );

#include "NwkTasksTbl.h"

/****************************************************************************
*****************************************************************************
* Public functions
*****************************************************************************
****************************************************************************/

#endif /* _NWK_GLOBALS_H_ */
